///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Main file for IceCore.dll.
 *	\file		IceCore.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICECORE_H__
#define __ICECORE_H__

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Compilation messages

#ifndef __cplusplus
	#error ICE needs C++ compilation...
#endif

#if defined(ICECORE_EXPORTS)
	#pragma message("Compiling ICE Core")
#elif !defined(ICECORE_EXPORTS)
	#pragma message("Using ICE Core")
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Includes

// Windows includes
#ifdef WIN32
#include <windows.h>												// General purpose Win32 functions
#include <windowsx.h>
#endif // WIN32

// DOS includes
#ifdef MSDOS
#include <dos.h>
#define DIR_STRUCT struct find_t
#define FIND_FIRST( n, d, a ) _dos_findfirst( n, a, d )
#define FIND_NEXT _dos_findnext
#define DIR_FILE_NAME name
#endif // MSDOS

// VMS includes
#ifdef VMS
#include <ssdef.h>
#include <rmsdef.h>
#include <descrip.h>
#endif // VMS

// Standard includes
#ifdef _DEBUG
#include <crtdbg.h>													// C runtime debug functions
#endif
#include <stdio.h>													// Standard Input/Output functions
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>													// Assertion functions
#include <shlobj.h>
#include <mmsystem.h>
#include <stdarg.h>
#include <time.h>
#include <float.h>

	// Error codes for IceCore
	#define EC_OUTOFMEMORY			"Out of memory"
	#define EC_FILENOTFOUND			"File not found"
	#define EC_INVALIDCALLBACK		"Invalid callback"
	#define EC_REPLICATIONFAILED	"Cloning process has failed"
	#define EC_TOOMANYMSGS			"Too many unread messages. Kernel has automatically disabled messages"
	#define EC_CORRUPTEDKERNEL		"Kernel is corrupted"
	#define EC_LOSTCELLS			"Kernel contains lost cells"
	#define EC_INCOMPATIBLEFIELDS	"Fields are not compatible"

	// Messages codes for IceCore
	#define KM_SELFDESTRUCT			"Kernel has sent a self-destruction order"
	#define KM_CORRUPTEDDELETION	"A cell has been deleted while still referenced"
	#define KM_INVALIDREFERENCE		"Provided reference is now invalid"
	#define KM_CELLMODIFICATION		"Provided cell has been modified by the kernel"
	#define KM_FIELDMODIFICATION	"Provided field has been modified"

// ICE includes
	#include "IceQuote.h"
	#include "IcePreprocessor.h"
	#include "IceTypes.h"
	#include "IceUtils.h"
	#include "IceDynID.h"
	#include "IceCPUID.h"
	#include "IceMemoryMacros.h"
	#include "IceMemoryManager.h"
	#include "IceDll.h"
	#include "IceQSort.h"
	#include "IceNLogLogN.h"
	#include "IceLog.h"

	namespace IceCore
	{
		#include "IceFPU.h"
		#include "IceLinkedList.h"
		#include "IceContainer.h"
		#include "IceStack.h"
		#include "IceCustomArray.h"
		#include "IceXList.h"

		#include "IceTrashBuffer.h"
		#include "IceInstrumentTrace.h"
		#include "IceString.h"
		#include "IceMsg.h"
		#include "IceError.h"
		#include "IceKeyboard.h"
		#include "IceFile.h"
		#include "IceBuffer.h"
		#include "IceCRC.h"

//		#include "IceQSort.h"
		#include "IceRevisitedRadix.h"

		#include "IceProfiler.h"
		#include "IceImportExport.h"
		#include "IceRefTracker.h"
		#include "IceCell.h"
		#include "IceCustomList.h"
		#include "IceKernel.h"
		#include "IceSmartContainer.h"

		#include "IceRegistry.h"
		#include "IceParser.h"
		#include "IceTimer.h"
		#include "IceTimeInfo.h"
		#include "IceHNode.h"
		#include "IceNotifSystem.h"
	}

	ICECORE_API bool	CheckSingleRun(const char* appname);
	ICECORE_API void	Dump(const char* filename, const char* text);

	//! A function to test the DLL components.
	ICECORE_API void	TestIceCore();

#endif // __ICECORE_H__

